/*
 * Copyright (C) 2009 Niek Linnenbank
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __DOXYGEN_H
#define __DOXYGEN_H

/**
 * @mainpage FreeNOS Documentation
 * @section About
 *
 * This documentation is for FreeNOS (Free Niek's Operating System).
 * FreeNOS is an experimental operating system for learning purposes, licensed under the GPLv3.
 *
 * $Revision: 116 $
 * @see http://www.freenos.org/
 * @see http://gplv3.fsf.org/
 *
 * @section building Building
 *
 * $ scons iso
 *
 * @section booting_qemu Booting under Qemu
 *
 * $ scons qemu
 *
 * @section booting_qemu_curses Booting under Qemu with Curses console
 *
 * $ scons qemu_curses
 *
 * @section booting_qemu_sdl Booting under Qemu with SDL console
 *
 * $ scons qemu_sdl
 *
 * @section booting_bochs Booting under Bochs
 *
 * $ scons bochs
 *
 * @section debugging_qemu Debugging under Qemu
 *
 * $ scons qemu_debug
 *
 * @section debugging_bochs Debugging under Bochs
 *
 * $ scons bochs_debug
 *
 * @section cleaning Cleaning up
 *
 * $ scons -c .
 *
 * @section snapshots Creating a snapshot
 *
 * $ scons snapshot
 *
 * @section releasing Creating a release
 *
 * $ scons release
 *
 */

#endif /* __DOXYGEN_H */
